
// VERSION: Scilab: 5.4.1 
// OS: windows 7

//CAPTION: Write a program to find the fourier series coefficients of a signal.

fig_size = [232 84 774 624];
x = [0.1 0.9 0.1];// % 1 period of x(t)
x = [x x x x]; //% 4 periods of x(t)
tx = [-2 -1 0 0 1 2 2 3 4 4 5 6]; //% time points for x(t)
subplot(2,2,1)
plot(tx,x)
xlabel('Time (s)')
ylabel('Amplitude'),...
title('Periodic Signal x(t)')
 
a0 = 0.5; // DC component of Fourier Series
ph0 = 0;
n = [1 3 5 7 9];// Values of n to be evaluated
an = -3.2 ./ (%pi * n).^2; //% Fourier Series coefficients
mag_an = abs(an);
ph_an = -180 * ones(1,length(n));
n = [0 n];
mag_an = [a0 mag_an];// % Including a0 with a_n
ph_an = [ph0 ph_an];
 
//Plotting fourier series magnitude
subplot(2,2,2)
plot(n,mag_an,'o');
xlabel('Harmonic Number');
ylabel('Magnitude');
title('Fourier Series Magnitude')

//Plotting fourier series phase
subplot(2,2,3)
plot(n,ph_an,'o')
xlabel('Harmonic Number')
ylabel('Phase (deg)')
title('Fourier Series Phase'),
